from pydantic import BaseModel, Field
from bson import ObjectId
from datetime import datetime
from typing import Optional, List

class WorkforceBase(BaseModel):
    account_id: str
    user_id: str
    first_name: str
    last_name: str
    mobile_number: str
    email_id: str
    gender: str
    date_of_birth: datetime
    license_id: str
    national_id: str
    emergency_contact: str
    shift_timing: str
    address: str
    blood_group: str
    is_human: bool
    workforce_category_id: str
    skills: Optional[List[dict]] = []
    certifications: Optional[List[str]] = [] 
    workforce_category_name: str
    skills_name: str
    tag_name: Optional[str] = None

    # Optional fields
    cense_number: Optional[str] = None
    join_date: Optional[datetime] = Field(default_factory=datetime.utcnow)
    status: Optional[str] = "active"
    created_date: Optional[datetime] = Field(default_factory=datetime.utcnow)
    last_updated: Optional[datetime] = Field(default_factory=datetime.utcnow)

class Workforce(WorkforceBase):
    id: str
    w_id: Optional[int] = None

    class Config:
        arbitrary_types_allowed = True
        json_encoders = {ObjectId: str}
        allow_population_by_field_name = True

class WorkforceResponse(BaseModel):
    workforce_id: str
    account_id: str
    user_id: str
    first_name: str
    last_name: str
    mobile_number: str
    email_id: str
    gender: str
    date_of_birth: datetime
    license_id: str
    national_id: str
    emergency_contact: str
    shift_timing: str
    address: str
    blood_group: str
    is_human: bool
    created_date: Optional[datetime] = None
    last_updated: Optional[datetime] = None
    status: Optional[str] = None
    cense_number: Optional[str] = None
    join_date: Optional[datetime] = None
    is_fleet_assigned: Optional[bool] = None
    skills: Optional[List[dict]] = [] 
    w_id: Optional[int] = None
    workforce_category_name: str
    skills_name: str
    tag_name: Optional[str] = None
    workforce_category_id: Optional[str] = None

class WorkforceResponseList(BaseModel):
    total_count: int
    workforce: List[WorkforceResponse]

class WorkforceUpdate(BaseModel):
    account_id: Optional[str]
    user_id: Optional[str]
    first_name: Optional[str]
    last_name: Optional[str]
    mobile_number: Optional[str]
    email_id: Optional[str]
    gender: Optional[str]
    date_of_birth: Optional[datetime]
    license_id: Optional[str]
    national_id: Optional[str]
    emergency_contact: Optional[str]
    shift_timing: Optional[str]
    address: Optional[str]
    blood_group: Optional[str]
    is_human: Optional[bool]
    cense_number: Optional[str]
    status: Optional[str]
    workforce_category_id: Optional[str]

class WorkforceCreate(WorkforceBase):
    pass

class WorkforceInDB(WorkforceBase):
    pass

class WorkforceDetailsRequest(BaseModel):
    workforce_id: Optional[str] = None 